﻿using Microsoft.SPOT;
using Microsoft.SPOT.Time;
using System;
using System.Net;

namespace NtpTest
{
    public class Program
    {
        static void TimeService_TimeSyncFailed(object sender, TimeSyncFailedEventArgs e)
        {
            Debug.Print("Error synchronizing system time with NTP server: " + e.ErrorCode);
        }
        
        private static void TimeService_SystemTimeChanged(object sender, SystemTimeChangedEventArgs e)
        {
            Debug.Print("Network time received");
        }

        public static void Main()
        {
            TimeService.SystemTimeChanged += new SystemTimeChangedEventHandler(TimeService_SystemTimeChanged);
            TimeService.TimeSyncFailed += new TimeSyncFailedEventHandler(TimeService_TimeSyncFailed); 
            
            TimeServiceSettings settings = new TimeServiceSettings();
            settings.ForceSyncAtWakeUp = true;
            settings.RefreshTime = 1800;
            IPAddress[] address = Dns.GetHostEntry("time-a.nist.gov").AddressList;
            //IPAddress[] address = Dns.GetHostEntry("time.windows.com").AddressList;
            if ((address != null) && (address.Length > 0))
            {
                settings.PrimaryServer = address[0].GetAddressBytes();
            }
            else
            {
                address = Dns.GetHostEntry("pool.ntp.org").AddressList;
                if ((address != null) && (address.Length > 0))
                {
                    settings.AlternateServer = address[0].GetAddressBytes();
                }
                else
                {
                    throw new Exception("NTP server lookup attempts failed");
                }
            }
            TimeService.Settings = settings;

            TimeService.SetTimeZoneOffset(120);     // UTC + 2 hours (Berlin, Berne, Rome)
            TimeService.Start();

            TimeService.UpdateNow(10000);
            Debug.Print("date/time: " + DateTime.Now);
        }
    }
}
