﻿using System;
using System.Collections;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Presentation;
using Microsoft.SPOT.Presentation.Controls;
using Microsoft.SPOT.Presentation.Media;
using Microsoft.SPOT.Touch;

using Gadgeteer.Networking;
using GT = Gadgeteer;
using GTM = Gadgeteer.Modules;

namespace ButtonForMountaineer_42_Test
{
    public partial class Program
    {
        GT.Timer buttonTimer = new GT.Timer(1000);
        GTM.Mountaineer.ButtonForMountaineer builtInButton;

        // This method is run when the mainboard is powered up or reset.   
        void ProgramStarted()
        {
            builtInButton = new GTM.Mountaineer.ButtonForMountaineer();
            builtInButton.ButtonPressed += new GTM.Mountaineer.ButtonForMountaineer.ButtonEventHandler(builtInButton_ButtonPressed);
            builtInButton.ButtonReleased += new GTM.Mountaineer.ButtonForMountaineer.ButtonEventHandler(builtInButton_ButtonReleased);

            buttonTimer.Tick += new GT.Timer.TickEventHandler(buttonTimer_Tick);
            buttonTimer.Start();

            // Use Debug.Print to show messages in Visual Studio's "Output" window during debugging.
            Debug.Print("Program Started");
        }

        void buttonTimer_Tick(GT.Timer timer)
        {
            if (this.builtInButton.isButtonPressed)
            {
                Debug.Print("Polling: button pressed");
            }
            else
            {
                Debug.Print("Polling: button released");
            }
        }

        void builtInButton_ButtonReleased(GTM.Mountaineer.ButtonForMountaineer sender, GTM.Mountaineer.ButtonForMountaineer.ButtonState value)
        {
            Debug.Print("Event: button released");
        }

        void builtInButton_ButtonPressed(GTM.Mountaineer.ButtonForMountaineer sender, GTM.Mountaineer.ButtonForMountaineer.ButtonState value)
        {
            Debug.Print("Event: button pressed");
        }
    }
}