﻿using System;
using Microsoft.SPOT;
using Microsoft.SPOT.Net.NetworkInformation;

using GT = Gadgeteer;
using GTM = Gadgeteer.Modules;
using GTI = Gadgeteer.Interfaces;

using Mountaineer.Netmf.Hardware;

namespace Gadgeteer.Modules.Mountaineer
{
    /// <summary>
    /// A EthernetForMountaineerEth module for Microsoft .NET Gadgeteer
    /// </summary>
    public class EthernetForMountaineerEth : GTM.Module.NetworkModule
    {
        // Note: A constructor summary is auto-generated by the doc builder.
        /// <summary></summary>
        public EthernetForMountaineerEth()
        {
            NetworkInterface[] networkInterfaces = NetworkInterface.GetAllNetworkInterfaces();

            if (networkInterfaces == null)
            {
                throw new Exception("No network interface.");
            }

            foreach (NetworkInterface netif in networkInterfaces)
            {
                if (netif.NetworkInterfaceType == NetworkInterfaceType.Ethernet)
                {
                    this.NetworkSettings = netif;
                    break;
                }
            }

            if (NetworkSettings == null)
            {
                throw new Exception("No ethernet network interface.");
            }
        }

        /// <summary>
        /// Gets a value that indicates whether this network is connected.
        /// </summary>
        public override bool IsNetworkConnected
        {
            get 
            {
                // TODO: is network connected not implemented
                return true;
            }
        }
    }
}
