﻿using System;
using System.Collections;
using System.Threading;
using Microsoft.SPOT;
using Microsoft.SPOT.Net.NetworkInformation;
using Microsoft.SPOT.Presentation;
using Microsoft.SPOT.Presentation.Controls;
using Microsoft.SPOT.Presentation.Media;
using Microsoft.SPOT.Touch;

using Gadgeteer.Networking;
using GT = Gadgeteer;
using GTM = Gadgeteer.Modules;

namespace EthernetForMountaineerEth_42_Test
{
    public partial class Program
    {
        GTM.Mountaineer.EthernetForMountaineerEth ethernet;
        GT.Timer netTimer = new GT.Timer(10000);

        // This method is run when the mainboard is powered up or reset.   
        void ProgramStarted()
        {
            ethernet = new GTM.Mountaineer.EthernetForMountaineerEth();
            ethernet.NetworkUp += new GTM.Module.NetworkModule.NetworkEventHandler(ethernet_NetworkUp);
            ethernet.NetworkDown += new GTM.Module.NetworkModule.NetworkEventHandler(ethernet_NetworkDown);

            netTimer.Tick += new GT.Timer.TickEventHandler(netTimer_Tick);
            netTimer.Start();

            // Use Debug.Print to show messages in Visual Studio's "Output" window during debugging.
            Debug.Print("Program Started");
        }

        void netTimer_Tick(GT.Timer timer)
        {
            String ipAddress = ethernet.NetworkSettings.IPAddress.ToString();

            if (!ipAddress.Equals("0.0.0.0"))
            {
                Debug.Print("IP Address: " + ethernet.NetworkSettings.IPAddress.ToString());
                Debug.Print("Subnet Mask: " + ethernet.NetworkSettings.SubnetMask.ToString());
                Debug.Print("Gateway: " + ethernet.NetworkSettings.GatewayAddress.ToString());
                Debug.Print("DNS Server: " + ethernet.NetworkSettings.DnsAddresses[0].ToString());

                timer.Stop();
            }
        }

        void ethernet_NetworkDown(GTM.Module.NetworkModule sender, GTM.Module.NetworkModule.NetworkState state)
        {
            Debug.Print("Network is Down");
        }

        void ethernet_NetworkUp(GTM.Module.NetworkModule sender, GTM.Module.NetworkModule.NetworkState state)
        {
            Debug.Print("Network is Up");
        }
    }
}
